% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_update_elasticsearch_domain_config}
\alias{elasticsearchservice_update_elasticsearch_domain_config}
\title{Modifies the cluster configuration of the specified Elasticsearch
domain, setting as setting the instance type and the number of instances}
\usage{
elasticsearchservice_update_elasticsearch_domain_config(
  DomainName,
  ElasticsearchClusterConfig = NULL,
  EBSOptions = NULL,
  SnapshotOptions = NULL,
  VPCOptions = NULL,
  CognitoOptions = NULL,
  AdvancedOptions = NULL,
  AccessPolicies = NULL,
  LogPublishingOptions = NULL,
  DomainEndpointOptions = NULL,
  AdvancedSecurityOptions = NULL,
  NodeToNodeEncryptionOptions = NULL,
  EncryptionAtRestOptions = NULL,
  AutoTuneOptions = NULL,
  DryRun = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the Elasticsearch domain that you are updating.}

\item{ElasticsearchClusterConfig}{The type and number of instances to instantiate for the domain cluster.}

\item{EBSOptions}{Specify the type and size of the EBS volume that you want to use.}

\item{SnapshotOptions}{Option to set the time, in UTC format, for the daily automated snapshot.
Default value is \code{0} hours.}

\item{VPCOptions}{Options to specify the subnets and security groups for VPC endpoint. For
more information, see \if{html}{\out{<a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html#es-creating-vpc"
target="_blank">}}Creating a VPC\if{html}{\out{</a>}} in \emph{VPC Endpoints for Amazon
Elasticsearch Service Domains}}

\item{CognitoOptions}{Options to specify the Cognito user and identity pools for Kibana
authentication. For more information, see \if{html}{\out{<a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
target="_blank">}}Amazon Cognito Authentication for Kibana\if{html}{\out{</a>}}.}

\item{AdvancedOptions}{Modifies the advanced option to allow references to indices in an HTTP
request body. Must be \code{false} when configuring access to individual
sub-resources. By default, the value is \code{true}. See \if{html}{\out{<a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#es-createdomain-configure-advanced-options"
target="_blank">}}Configuration Advanced Options\if{html}{\out{</a>}} for more information.}

\item{AccessPolicies}{IAM access policy as a JSON-formatted string.}

\item{LogPublishingOptions}{Map of \code{LogType} and \code{LogPublishingOption}, each containing options to
publish a given type of Elasticsearch log.}

\item{DomainEndpointOptions}{Options to specify configuration that will be applied to the domain
endpoint.}

\item{AdvancedSecurityOptions}{Specifies advanced security options.}

\item{NodeToNodeEncryptionOptions}{Specifies the NodeToNodeEncryptionOptions.}

\item{EncryptionAtRestOptions}{Specifies the Encryption At Rest Options.}

\item{AutoTuneOptions}{Specifies Auto-Tune options.}

\item{DryRun}{This flag, when set to True, specifies whether the
\code{UpdateElasticsearchDomain} request should return the results of
validation checks without actually applying the change. This flag, when
set to True, specifies the deployment mechanism through which the update
shall be applied on the domain. This will not actually perform the
Update.}
}
\description{
Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.

See \url{https://www.paws-r-sdk.com/docs/elasticsearchservice_update_elasticsearch_domain_config/} for full documentation.
}
\keyword{internal}
