% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_start_query_execution}
\alias{athena_start_query_execution}
\title{Runs the SQL query statements contained in the Query}
\usage{
athena_start_query_execution(QueryString, ClientRequestToken,
  QueryExecutionContext, ResultConfiguration, WorkGroup)
}
\arguments{
\item{QueryString}{[required] The SQL query statements to be executed.}

\item{ClientRequestToken}{A unique case-sensitive string used to ensure the request to create the
query is idempotent (executes only once). If another
\code{StartQueryExecution} request is received, the same response is returned
and another query is not created. If a parameter has changed, for
example, the \code{QueryString}, an error is returned.

This token is listed as not required because AWS SDKs (for example the
AWS SDK for Java) auto-generate the token for users. If you are not
using the AWS SDK or the AWS CLI, you must provide this token or the
action will fail.}

\item{QueryExecutionContext}{The database within which the query executes.}

\item{ResultConfiguration}{Specifies information about where and how to save the results of the
query execution. If the query runs in a workgroup, then workgroup\'s
settings may override query settings. This affects the query results
location. The workgroup settings override is specified in
EnforceWorkGroupConfiguration (true/false) in the
WorkGroupConfiguration. See
WorkGroupConfiguration\\$EnforceWorkGroupConfiguration.}

\item{WorkGroup}{The name of the workgroup in which the query is being started.}
}
\description{
Runs the SQL query statements contained in the \code{Query}. Requires you to
have access to the workgroup in which the query ran.
}
\details{
For code samples using the AWS SDK for Java, see \href{http://docs.aws.amazon.com/athena/latest/ug/code-samples.html}{Examples and Code Samples}
in the \emph{Amazon Athena User Guide}.
}
\section{Request syntax}{
\preformatted{svc$start_query_execution(
  QueryString = "string",
  ClientRequestToken = "string",
  QueryExecutionContext = list(
    Database = "string"
  ),
  ResultConfiguration = list(
    OutputLocation = "string",
    EncryptionConfiguration = list(
      EncryptionOption = "SSE_S3"|"SSE_KMS"|"CSE_KMS",
      KmsKey = "string"
    )
  ),
  WorkGroup = "string"
)
}
}

\keyword{internal}
