% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_theme}
\alias{quicksight_create_theme}
\title{Creates a theme}
\usage{
quicksight_create_theme(AwsAccountId, ThemeId, Name, BaseThemeId,
  VersionDescription, Configuration, Permissions, Tags)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account where you want to store the new theme.}

\item{ThemeId}{[required] An ID for the theme that you want to create. The theme ID is unique per
AWS Region in each AWS account.}

\item{Name}{[required] A display name for the theme.}

\item{BaseThemeId}{[required] The ID of the theme that a custom theme will inherit from. All themes
inherit from one of the starting themes defined by Amazon QuickSight.
For a list of the starting themes, use \code{ListThemes} or choose \strong{Themes}
from within a QuickSight analysis.}

\item{VersionDescription}{A description of the first version of the theme that you're creating.
Every time \code{UpdateTheme} is called, a new version is created. Each
version of the theme has a description of the version in the
\code{VersionDescription} field.}

\item{Configuration}{[required] The theme configuration, which contains the theme display properties.}

\item{Permissions}{A valid grouping of resource permissions to apply to the new theme.}

\item{Tags}{A map of the key-value pairs for the resource tag or tags that you want
to add to the resource.}
}
\description{
Creates a theme.

A \emph{theme} is set of configuration options for color and layout. Themes
apply to analyses and dashboards. For more information, see \href{https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html}{Using Themes in Amazon QuickSight}
in the \emph{Amazon QuickSight User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_theme(
  AwsAccountId = "string",
  ThemeId = "string",
  Name = "string",
  BaseThemeId = "string",
  VersionDescription = "string",
  Configuration = list(
    DataColorPalette = list(
      Colors = list(
        "string"
      ),
      MinMaxGradient = list(
        "string"
      ),
      EmptyFillColor = "string"
    ),
    UIColorPalette = list(
      PrimaryForeground = "string",
      PrimaryBackground = "string",
      SecondaryForeground = "string",
      SecondaryBackground = "string",
      Accent = "string",
      AccentForeground = "string",
      Danger = "string",
      DangerForeground = "string",
      Warning = "string",
      WarningForeground = "string",
      Success = "string",
      SuccessForeground = "string",
      Dimension = "string",
      DimensionForeground = "string",
      Measure = "string",
      MeasureForeground = "string"
    ),
    Sheet = list(
      Tile = list(
        Border = list(
          Show = TRUE|FALSE
        )
      ),
      TileLayout = list(
        Gutter = list(
          Show = TRUE|FALSE
        ),
        Margin = list(
          Show = TRUE|FALSE
        )
      )
    )
  ),
  Permissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
