% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_list_applications}
\alias{kinesisanalytics_list_applications}
\title{Returns a list of Amazon Kinesis Analytics applications in your account}
\usage{
kinesisanalytics_list_applications(Limit, ExclusiveStartApplicationName)
}
\arguments{
\item{Limit}{Maximum number of applications to list.}

\item{ExclusiveStartApplicationName}{Name of the application to start the list with. When using pagination to
retrieve the list, you don't need to specify this parameter in the
first request. However, in subsequent requests, you add the last
application name from the previous response to get the next page of
applications.}
}
\description{
Returns a list of Amazon Kinesis Analytics applications in your account.
For each application, the response includes the application name, Amazon
Resource Name (ARN), and status. If the response returns the
\code{HasMoreApplications} value as true, you can send another request by
adding the \code{ExclusiveStartApplicationName} in the request body, and set
the value of this to the last application name from the previous
response.
}
\details{
If you want detailed information about a specific application, use
DescribeApplication.

This operation requires permissions to perform the
\code{kinesisanalytics:ListApplications} action.
}
\section{Request syntax}{
\preformatted{svc$list_applications(
  Limit = 123,
  ExclusiveStartApplicationName = "string"
)
}
}

\keyword{internal}
