% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_list_steps}
\alias{emr_list_steps}
\title{Provides a list of steps for the cluster in reverse order unless you
specify stepIds with the request}
\usage{
emr_list_steps(ClusterId, StepStates, StepIds, Marker)
}
\arguments{
\item{ClusterId}{[required] The identifier of the cluster for which to list the steps.}

\item{StepStates}{The filter to limit the step list based on certain states.}

\item{StepIds}{The filter to limit the step list based on the identifier of the steps.}

\item{Marker}{The pagination token that indicates the next set of results to retrieve.}
}
\description{
Provides a list of steps for the cluster in reverse order unless you
specify stepIds with the request.
}
\section{Request syntax}{
\preformatted{svc$list_steps(
  ClusterId = "string",
  StepStates = list(
    "PENDING"|"CANCEL_PENDING"|"RUNNING"|"COMPLETED"|"CANCELLED"|"FAILED"|"INTERRUPTED"
  ),
  StepIds = list(
    "string"
  ),
  Marker = "string"
)
}
}

\keyword{internal}
