% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataBank.R
\name{dataBank}
\alias{dataBank}
\title{Data Bank Initialization Function}
\usage{
dataBank(type, dimensions)
}
\arguments{
\item{type}{A character string specifying the type of data structure to initialize: "array", "vector", "matrix", or
"neighborhood memories". Each structure serves different requirements for data storage and processing in the model.}

\item{dimensions}{An integer vector specifying the dimensions of the data structure. The interpretation of dimensions
varies based on the type:
\itemize{
\item For "array", it defines the dimensions of the array.
\item For "vector", only the first element (length) is used.
\item For "matrix", the first two elements specify the number of rows and columns.
\item For "neighborhood memories", the first two elements define the number of rows and columns,
the third element specifies the number of nearest neighbors, and the fourth element details the number
of signature components per neighbor.
}}
}
\value{
db Returns the initialized data structure, filled with NA values. Depending on the 'type', the structure
can be an array, vector, matrix, or a specialized data frame designed for neighborhood memories which incorporates
extensive details about interactions within defined neighborhoods.
}
\description{
Initializes various data structures for storing and managing data within a complex systems analysis framework.
}
\examples{
# Initialize a matrix with 3 rows and 5 columns.
matrix_db <- dataBank("matrix", c(3, 5))
print(matrix_db)

# Initialize a neighborhood memory structure correctly with sufficient column names.
dimensions_nm <- c(4, 40, 3, 5)
nm_db <- dataBank("neighborhood memories", dimensions_nm)
print(nm_db)
}
