% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_subjectProfileCombine.R
\name{prepareSubjectProfile}
\alias{prepareSubjectProfile}
\title{prepare list of subject profile (s) to be combined with the \code{\link{combineVerticallyGGplot}}}
\usage{
prepareSubjectProfile(
  ...,
  labels,
  timeLim = NULL,
  refLines = NULL,
  refLinesData = NULL,
  refLinesTimeVar = NULL,
  refLinesLabelVar = NULL,
  subjectVar = "USUBJID",
  timeTrans = NULL,
  timeExpand = NULL
)
}
\arguments{
\item{...}{list of subject profiles (across modules)}

\item{labels}{string with labels for the plots}

\item{timeLim}{time limits, as returned by the
\code{\link{getTimeLimSubjectProfilePlots}} function.}

\item{refLines}{(optional) nested list with details for reference line(s).
Each sublist contains:
\itemize{
\item{(required) 'label': string with label for the reference line}
\item{(required) 'time': unique time (x) coordinate for the reference line}
\item{(optional) 'color': color for the reference line,
'black' by default}
\item{(optional) 'linetype': linetype for the reference line,
'dotted' by default}
}}

\item{refLinesData}{data.frame with data from which the reference line(s) should be extracted}

\item{refLinesTimeVar}{string, variable of \code{refLinesData} with time for reference line(s)}

\item{refLinesLabelVar}{string, variable of \code{refLinesData} with label for reference line(s)}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{timeTrans}{Time transformation, or list of such transformation
named by module. If NULL, no transformation are done.}

\item{timeExpand}{Vector of range expansion constants for the time axis
(see \code{expand} parameter in \code{\link[ggplot2]{scale_x_continuous}}).}
}
\value{
\code{subjectProfilePlot} object, containing the combined
profile plots
}
\description{
prepare list of subject profile (s) to be combined with the \code{\link{combineVerticallyGGplot}}
}
\author{
Laure Cougnaud
}
