% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{getOptimalColWidth}
\alias{getOptimalColWidth}
\title{Get optimal column widths, based on the minimum word size
and median number of characters in each column.}
\usage{
getOptimalColWidth(
  data,
  widthValue = ifelse(formatReport$landscape, 240, 190),
  labels = NULL,
  formatReport = subjectProfileReportFormat()
)
}
\arguments{
\item{data}{Data.frame with columns for which optimal width should be extracted.}

\item{widthValue}{max number of characters in the code{paramValueVar} parameter.}

\item{labels}{(optional) Character vector with column labels for \code{data}.}

\item{formatReport}{list with parameters used to specify the format of the report,
e.g. output of the \code{\link{subjectProfileReportFormat}} function}
}
\value{
Numeric vector of \code{length(ncol(data))} with optimal widths.
}
\description{
Get optimal column widths, based on the minimum word size
and median number of characters in each column.
}
\author{
Laure Cougnaud
}
