% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{getColorPalettePatientProfile}
\alias{getColorPalettePatientProfile}
\title{Get a color palette for patient profile
visualizations.}
\usage{
getColorPalettePatientProfile(..., includeNA = TRUE)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[clinUtils:getColorPalette]{clinUtils::getColorPalette}}
  \describe{
    \item{\code{n}}{Integer of length 1, number of elements in palette.}
    \item{\code{x}}{Vector with elements used for palette.
If factor, the levels are used, otherwise the unique elements of the vector.
Missing values are automatically removed, excepted if
\code{includeNA} is set to TRUE.}
    \item{\code{palette}}{A vector of custom colors,
or a function returning this vector from a specific
number of colors.\cr
Default is the the colorblind 
\code{\link[viridisLite]{viridis}} color palette.}
  }}

\item{includeNA}{Logical (TRUE by default), 
should NA elements be retained in the palette in case
\code{x} is specified?}
}
\value{
Vector of shapes,
named with the elements in \code{x} if \code{x} is specified.
}
\description{
This is a simple wrapper around 
\link[clinUtils]{getColorPalette},
with different defaults:
\itemize{
\item{inclusion of missing values
by default (\code{includeNA} set to \code{TRUE})
}
}
}
\seealso{
\link[clinUtils]{getColorPalette}
}
\author{
Laure Cougnaud
}
