% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{lermanIndex}
\alias{lermanIndex}
\alias{lermanIndex,Partition,Partition,missing-method}
\alias{lermanIndex,Partition,Partition,PairCoefficients-method}
\title{Lerman Index}
\usage{
lermanIndex(p, q, c = NULL)

\S4method{lermanIndex}{Partition,Partition,missing}(p, q, c = NULL)

\S4method{lermanIndex}{Partition,Partition,PairCoefficients}(p, q, c = NULL)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}

\item{c}{\linkS4class{PairCoefficients} or NULL}
}
\description{
Compute the Lerman index
\deqn{\frac{N_{11} - E(N_{11})}{\sqrt{\sigma^2(N_{11})}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition,c = missing}: Compute given two partitions

\item \code{p = Partition,q = Partition,c = PairCoefficients}: Compute given the partitions and pair coefficients
}}

\examples{
isTRUE(all.equal(lermanIndex(new("Partition", c(0, 0, 0, 1, 1)), 
                             new("Partition", c(0, 0, 1, 1, 1))), 2/sqrt(21)))

}
\references{
\insertRef{Lerman1988}{partitionComparison}

\insertRef{Hubert1985}{partitionComparison}

\insertRef{Deneud2006}{partitionComparison}
}
\seealso{
\code{\link{normalizedLermanIndex}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
