% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{rogersTanimoto}
\alias{rogersTanimoto}
\alias{rogersTanimoto,Partition,Partition-method}
\alias{rogersTanimoto,PairCoefficients,missing-method}
\title{Rogers & Tanimoto Index}
\usage{
rogersTanimoto(p, q)

\S4method{rogersTanimoto}{Partition,Partition}(p, q)

\S4method{rogersTanimoto}{PairCoefficients,missing}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index of Rogers and Tanimoto
\deqn{\frac{N_{11} + N_{00}}{N_{11} + 2(N_{10} + N_{01}) + N_{00}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
rogersTanimoto(new("Partition", c(0, 0, 0, 1, 1)), 
               new("Partition", c(0, 0, 1, 1, 1))) == 3/7

}
\references{
\insertRef{Rogers1960}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
