% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{jaccardCoefficient}
\alias{jaccardCoefficient}
\alias{jaccardCoefficient,Partition,Partition-method}
\alias{jaccardCoefficient,PairCoefficients,missing-method}
\title{Jaccard Coefficient}
\usage{
jaccardCoefficient(p, q)

\S4method{jaccardCoefficient}{Partition,Partition}(p, q)

\S4method{jaccardCoefficient}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Jaccard coefficient
\deqn{\frac{N_{11}}{N_{11} + N_{10} + N_{01}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
jaccardCoefficient(new("Partition", c(0, 0, 0, 1, 1)), 
                   new("Partition", c(0, 0, 1, 1, 1))) == 1/3

}
\references{
\insertRef{Jaccard1908}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
