% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{as_partition_step}
\alias{as_partition_step}
\title{Create a partition object from a data frame}
\usage{
as_partition_step(.x, threshold = NA, reduced_data = NA, target = NA,
  metric = NA, tolerance = 0.01, var_prefix = NA, partitioner = NA,
  ...)
}
\arguments{
\item{.x}{a \code{data.frame} or \code{partition_step} object}

\item{threshold}{The minimum information loss allowable}

\item{reduced_data}{A data set with reduced variables}

\item{target}{A character or integer vector: the variables to reduce}

\item{metric}{A measure of information}

\item{tolerance}{A tolerance around the threshold to accept a reduction}

\item{var_prefix}{Variable name for reduced variables}

\item{partitioner}{A \code{partitioner}, a \code{part_*()} function or one created with
\code{\link[=as_partitioner]{as_partitioner()}}.}

\item{...}{Other objects to store during the partition step}
}
\value{
a \code{partition_step} object
}
\description{
\code{as_partition_step()} creates a \code{partition_step} object. \code{partition_step}s
are used while iterating through the partition algorithm: it stores necessary
information about how to proceed in the partitioning, such as the information
threshold. \code{as_partition_step()} is primarily called internally by
\code{partition()} but can be helpful while developing \code{partitioners}.
}
\examples{
.df <- data.frame(x = rnorm(100), y = rnorm(100))
as_partition_step(.df, threshold = .6)
}
