% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_nnet.R
\name{details_mlp_nnet}
\alias{details_mlp_nnet}
\title{Multilayer perceptron via nnet}
\description{
\code{\link[nnet:nnet]{nnet::nnet()}} fits a single layer, feed-forward neural network.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{hidden_units}: # Hidden Units (type: integer, default: none)
\item \code{penalty}: Amount of Regularization (type: double, default: 0.0)
\item \code{epochs}: # Epochs (type: integer, default: 100L)
}

Note that, in \code{\link[nnet:nnet]{nnet::nnet()}}, the maximum number of
parameters is an argument with a fairly low value of \code{maxit = 1000}. For
some models, you may need to pass this value in via
\code{\link[=set_engine]{set_engine()}} so that the model does not fail.
}

\subsection{Translation from parsnip to the original package (regression)}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{mlp(
  hidden_units = integer(1),
  penalty = double(1),
  epochs = integer(1)
) \%>\%  
  set_engine("nnet") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Single Layer Neural Network Specification (regression)
## 
## Main Arguments:
##   hidden_units = integer(1)
##   penalty = double(1)
##   epochs = integer(1)
## 
## Computational engine: nnet 
## 
## Model fit template:
## nnet::nnet(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     size = integer(1), decay = double(1), maxit = integer(1), 
##     trace = FALSE, linout = TRUE)
}

Note that parsnip automatically sets linear activation in the last
layer.
}

\subsection{Translation from parsnip to the original package (classification)}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{mlp(
  hidden_units = integer(1),
  penalty = double(1),
  epochs = integer(1)
) \%>\% 
  set_engine("nnet") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Single Layer Neural Network Specification (classification)
## 
## Main Arguments:
##   hidden_units = integer(1)
##   penalty = double(1)
##   epochs = integer(1)
## 
## Computational engine: nnet 
## 
## Model fit template:
## nnet::nnet(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     size = integer(1), decay = double(1), maxit = integer(1), 
##     trace = FALSE, linout = FALSE)
}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip
will convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#mlp-nnet}{examples}
for \code{mlp()} with the \code{"nnet"} engine.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
