% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextFactory.R
\name{ContextFactory}
\alias{ContextFactory}
\title{BackendFactory}
\description{
This class is a factory that provides instances of the \code{\link{Context}}
class.
}
\examples{
# Create a context factory.
context_factory <- ContextFactory$new()

# Get a regular context instance.
context <- context_factory$get("regular")

# Check the class of the context instance.
class(context)

# Get a progress context instance.
context <- context_factory$get("progress")
class(context)

}
\seealso{
\code{\link{Context}}, \code{\link{ProgressTrackingContext}},
\code{\link{Service}}, and \code{\link{Backend}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContextFactory-get}{\code{ContextFactory$get()}}
\item \href{#method-ContextFactory-clone}{\code{ContextFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextFactory-get"></a>}}
\if{latex}{\out{\hypertarget{method-ContextFactory-get}{}}}
\subsection{Method \code{get()}}{
Obtain instances of the \code{\link{Context}} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextFactory$get(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A character string specifying the type of the
\code{\link{Context}} to instantiate. Possible values are \code{"regular"}
and \code{"progress"}. See the \strong{Details} section for more information.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
When \code{type = "regular"} a \code{\link{Context}} instance is created
and returned. When \code{type = "progress"} a
\code{\link{ProgressTrackingContext}} instance is provided instead.
}

\subsection{Returns}{
An object of type \code{\link{Context}}. It throws an error if the
requested context \code{type} is not supported.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextFactory-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContextFactory-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
