% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pal.csf}
\alias{pal.csf}
\title{Show a colormap with a Campbell-Robson Contrast Sensitivity Chart}
\usage{
pal.csf(pal, n = 150, main = "")
}
\arguments{
\item{pal}{A continuous colormap function}

\item{n}{The number of colors to display for palette functions.}

\item{main}{Main title.}
}
\value{
None
}
\description{
In a contrast sensitivity figure as drawn by this function, the 
spatial frequency increases from left to right and the contrast decreases
from bottom to top.  The bars in the figure appear taller in the middle 
of the image than at the edges, creating an upside-down "U" shape, which 
is the "contrast sensitivity function".  
Your perception of this curve depends on the viewing distance.
}
\details{
What to look for:

1. Are the vertical bands visible across the full vertical axis?

2. Do the vertical bands blur together?
}
\examples{
pal.csf(brewer.greys) # Classic example from psychology
pal.csf(parula)

}
\references{
Izumi Ohzawa. Make Your Own Campbell-Robson Contrast Sensitivity Chart.
http://ohzawa-lab.bpe.es.osaka-u.ac.jp/ohzawa-lab/izumi/CSF/A_JG_RobsonCSFchart.html

Campbell, F. W. and Robson, J. G. (1968).
Application of Fourier analysis to the visibility of gratings. 
\emph{Journal of Physiology}, 197: 551-566.
}
\author{
Kevin Wright
}
