% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales-colour-mapping.R
\name{pal_numeric}
\alias{pal_numeric}
\alias{pal_bin}
\alias{pal_quantile}
\alias{pal_factor}
\title{Colour vector and colour palette mapping}
\usage{
pal_numeric(
  palette,
  domain,
  na.color = "#808080",
  alpha = FALSE,
  reverse = FALSE
)

pal_bin(
  palette,
  domain,
  bins = 7,
  pretty = TRUE,
  na.color = "#808080",
  alpha = FALSE,
  reverse = FALSE,
  right = FALSE
)

pal_quantile(
  palette,
  domain,
  n = 4,
  probs = seq(0, 1, length.out = n + 1),
  na.color = "#808080",
  alpha = FALSE,
  reverse = FALSE,
  right = FALSE
)

pal_factor(
  palette,
  domain,
  levels = NULL,
  ordered = FALSE,
  na.color = "#808080",
  alpha = FALSE,
  reverse = FALSE
)
}
\arguments{
\item{palette}{An object of class \code{palettes_palette} or \code{palettes_colour}.}

\item{domain}{The possible values that can be mapped.

For \code{pal_numeric} and \code{pal_bin}, this can be a simple numeric
range (e.g. \code{c(0, 100)}); \code{pal_quantile} needs representative
numeric data; and \code{pal_factor} needs categorical data.

If \code{NULL}, then whenever the resulting colour function is called, the
\code{x} value will represent the domain. This implies that if the function
is invoked multiple times, the encoding between values and colours may not
be consistent; if consistency is needed, you must provide a non-\code{NULL}
domain.}

\item{na.color}{The colour to return for \code{NA} values. Note that
\code{na.color = NA} is valid.}

\item{alpha}{Whether alpha channels should be respected or ignored. If \code{TRUE}
then colors without explicit alpha information will be treated as fully
opaque.}

\item{reverse}{Whether the colours in \code{palette} should be
used in reverse order. For example, if the default order of a palette goes
from blue to green, then \code{reverse = TRUE} will result in the colors going
from green to blue.}

\item{bins}{Either a numeric vector of two or more unique cut points or a
single number (greater than or equal to 2) giving the number of intervals
into which the domain values are to be cut.}

\item{pretty}{Whether to use the function \code{\link[=pretty]{pretty()}} to generate
the bins when the argument \code{bins} is a single number. When
\code{pretty = TRUE}, the actual number of bins may not be the number of
bins you specified. When \code{pretty = FALSE}, \code{\link[=seq]{seq()}} is used
to generate the bins and the breaks may not be "pretty".}

\item{right}{parameter supplied to \code{\link[base:cut]{base::cut()}}. See Details}

\item{n}{Number of equal-size quantiles desired. For more precise control,
use the \code{probs} argument instead.}

\item{probs}{See \code{\link[stats:quantile]{stats::quantile()}}. If provided, the \code{n}
argument is ignored.}

\item{levels}{An alternate way of specifying levels; if specified, domain is
ignored}

\item{ordered}{If \code{TRUE} and \code{domain} needs to be coerced to a
factor, treat it as already in the correct order}
}
\value{
A function that takes a single parameter \code{x}; when called with a
vector of numbers (except for \code{pal_factor}, which expects
factors/characters), #RRGGBB colour strings are returned (unless
\code{alpha = TRUE} in which case #RRGGBBAA may also be possible).
}
\description{
Conveniently maps data values (numeric or factor/character) to colours
according to a given colour vector or colour palette.
}
\details{
\code{pal_numeric} is a simple linear mapping from continuous numeric
data to an interpolated palette.

\code{pal_bin} also maps continuous numeric data, but performs
binning based on value (see the \code{\link[base:cut]{base::cut()}} function). \code{pal_bin}
defaults for the \code{cut} function are \code{include.lowest = TRUE} and
\code{right = FALSE}.

\code{pal_quantile} similarly bins numeric data, but via the
\code{\link[stats:quantile]{stats::quantile()}} function.

\code{pal_factor} maps factors to colours. If the palette is
discrete and has a different number of colours than the number of factors,
interpolation is used.
}
\examples{
pal <- pal_bin(met_palettes$Tam, domain = 0:100)
plot(as_colour(pal(sort(runif(16, 0, 100)))))

# Exponential distribution, mapped continuously
pal <- pal_numeric(met_palettes$Tam, domain = NULL)
plot(as_colour(pal(sort(rexp(16)))))

# Exponential distribution, mapped by interval
pal <- pal_bin(met_palettes$Tam, domain = NULL, bins = 4)
plot(as_colour(pal(sort(rexp(16)))))

# Exponential distribution, mapped by quantile
pal <- pal_quantile(met_palettes$Tam, domain = NULL)
plot(as_colour(pal(sort(rexp(16)))))

# Categorical data; by default, the values being coloured span the gamut...
pal <- pal_factor(met_palettes$Java, domain = NULL)
plot(as_colour(pal(LETTERS[1:5])))

# ...unless the data is a factor, without droplevels...
pal <- pal_factor(met_palettes$Java, domain = NULL)
plot(as_colour(pal(factor(LETTERS[1:5], levels = LETTERS))))

# ...or the domain is stated explicitly.
pal <- pal_factor(met_palettes$Java, domain = NULL, levels = LETTERS)
plot(as_colour(pal(LETTERS[1:5])))
}
\seealso{
\code{\link[scales:col_numeric]{scales::col_numeric()}}

\code{\link[scales:col_numeric]{scales::col_bin()}}

\code{\link[scales:col_numeric]{scales::col_quantile()}}

\code{\link[scales:col_numeric]{scales::col_factor()}}
}
