% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p1_liftover.R
\name{pagoda.reduce.loading.redundancy}
\alias{pagoda.reduce.loading.redundancy}
\title{Collapse aspects driven by the same combinations of genes.
(Aspects are some pattern across cells e.g. sequencing depth, 
or PC corresponding to an undesired process such as ribosomal pathway variation.)
Examines PC loading vectors underlying the identified aspects and clusters of aspects based
on a product of loading and score correlation (raised to corr.power). 
Clusters of aspects driven by the same genes are determined based 
on the parameter "distance.threshold".}
\usage{
pagoda.reduce.loading.redundancy(
  tam,
  pwpca,
  clpca = NULL,
  plot = FALSE,
  cluster.method = "complete",
  distance.threshold = 0.01,
  corr.power = 4,
  abs = TRUE,
  n.cores = 1,
  ...
)
}
\arguments{
\item{tam}{output of pagoda.top.aspects(), i.e. a list structure containing the following items:
xv: a matrix of normalized aspect patterns (rows: significant aspects, columns: cells)
xvw: corresponding weight matrix 
gw: set of genes driving the significant aspects 
df: text table with the significance testing results}

\item{pwpca}{output of pagoda.pathway.wPCA(), i.e. a list of weighted PCA info for each valid gene set}

\item{clpca}{output of pagoda.gene.clusters() (optional) (default=NULL). The output of pagoda.gene.clusters() is 
a list structure containing the following fields:
clusters: alist of genes in each cluster values
xf: extreme value distribution fit for the standardized lambda1 of a randomly generated pattern
tci: index of a top cluster in each random iteration
cl.goc: weighted PCA info for each real gene cluster
varm: standardized lambda1 values for each randomly generated matrix cluster
clvlm: a linear model describing dependency of the cluster lambda1 on a Tracy-Widom lambda1 expectation}

\item{plot}{boolean Whether to plot the resulting clustering (default=FALSE)}

\item{cluster.method}{string One of the standard clustering methods to be used (default="complete")}

\item{distance.threshold}{numeric Similarity threshold for grouping interdependent aspects (default=0.01)}

\item{corr.power}{numeric Power to which the product of loading and score correlation is raised (default=4)}

\item{abs}{boolean Whether to use absolute correlation (default=TRUE)}

\item{n.cores}{numeric Number of cores to use during processing (default=1)}

\item{...}{additional arguments are passed to the pagoda.view.aspects() method during plotting}
}
\value{
a list structure analogous to that returned by pagoda.top.aspects(), but with addition of a $cnam element containing a list of aspects summarized by each row of the new (reduced) $xv and $xvw
}
\description{
Collapse aspects driven by the same combinations of genes.
(Aspects are some pattern across cells e.g. sequencing depth, 
or PC corresponding to an undesired process such as ribosomal pathway variation.)
Examines PC loading vectors underlying the identified aspects and clusters of aspects based
on a product of loading and score correlation (raised to corr.power). 
Clusters of aspects driven by the same genes are determined based 
on the parameter "distance.threshold".
}
