% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_functions.R
\name{fill_by_value}
\alias{fill_by_value}
\title{Fill missing values by a single value.}
\usage{
fill_by_value(x, ..., value = 0)
}
\arguments{
\item{x}{A data frame.}

\item{...}{The unquoted column names of the variables that should be filled.}

\item{value}{The value to replace the missing values by.}
}
\value{
\code{x} with the altered columns.
}
\description{
Replace all missing values in the specified columns by the same value.
}
\examples{
library(dplyr) # for the pipe operator
x <- seq(as.Date('2016-01-01'), by = 'day', length.out = 366)
x <- x[sample(1:366, 200)] \%>\% sort
x_df <- data_frame(x  = x,
                   y1 = runif(200, 10, 20) \%>\% round,
                   y2 = runif(200, 1, 50) \%>\% round,
                   y3 = runif(200, 20, 40) \%>\% round,
                   y4 = sample(letters[1:5], 200, replace = TRUE))
x_padded <- x_df \%>\% pad
x_padded \%>\% fill_by_value(y1)
x_df \%>\% pad \%>\% fill_by_value(y1, y2, value = 42)
}

