% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{add_github_url_to_desc}
\alias{add_github_url_to_desc}
\title{Add a \verb{github} \acronym{URL} to File \file{DESCRIPTION}}
\usage{
add_github_url_to_desc(path = ".", default_gh_user = NULL, normalize = TRUE)
}
\arguments{
\item{path}{Path to the package directory (see
\code{\link[devtools:as.package]{devtools::as.package}}).}

\item{default_gh_user}{See details.}

\item{normalize}{Passed to
\code{\link[desc:desc_set_urls]{desc::desc_set_urls}}.}
}
\value{
\code{\link[=invisible]{Invisibly} \link[=logical]{TRUE}} if
adding a \verb{github} \acronym{URL}, \code{\link[=logical]{FALSE}}
otherwise.
}
\description{
\acronym{URL}.
}
\details{
The \acronym{URL} is constructed by the package's name as read from it's file
\file{DESCRIPTION}, and the username returned by
\code{\link[whoami:gh_username]{whoami::gh_username}}.
\code{\link[whoami:gh_username]{whoami::gh_username}} allows for a fallback,
this is given by \code{default_gh_user}.
You can specify \code{default_gh_user = NA}, to try to retrieve the username
by searching remotes on \verb{github} if the
package is a git repository. We do not use
\code{\link[git2r:config]{git2r::config}} since there's no way to make sure
the configured git user name, locally or globally, is a \verb{github}
username.
}
\examples{
path <- file.path(tempdir(), "myPackage")
usethis::create_package(path, open = FALSE)
add_github_url_to_desc(path)
grep("^URL:", readLines(file.path(path, "DESCRIPTION")), value = TRUE)
unlink(path, recursive = TRUE)
}
\keyword{internal}
