% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_help_functions.R
\name{create_table_from_gtsummary_compare_twogroups}
\alias{create_table_from_gtsummary_compare_twogroups}
\title{Create a table to compare the descriptive analysis from gtsummary of
two groups}
\usage{
create_table_from_gtsummary_compare_twogroups(variables, gtsummary, name_use)
}
\arguments{
\item{variables}{variables that interested}

\item{gtsummary}{a gtsummary object that contains summary parameters}

\item{name_use}{name of the variable or category}
}
\value{
the table
}
\description{
Create a table to compare the descriptive analysis from gtsummary of
two groups
}
\examples{
eg_data <- as.data.frame(list(no = c(1,2,3,4), mark = c(12,34,23,45),
gender = c("M", "F", "M", "F")))
outcome_summary <- IPDFileCheck::get_summary_gtsummary(eg_data,
c("gender", "mark"), byvar = "gender")
variables <- "Mark"
create_table_from_gtsummary_compare_twogroups(variables,
outcome_summary, "Category")
}
