% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpbf_mun.R
\name{getpbf_mun}
\alias{getpbf_mun}
\title{Collects municipal level data from the program BOLSA FAMILIA database.}
\usage{
getpbf_mun(IBGECODE, AAAA, MM, PAGE)
}
\arguments{
\item{IBGECODE}{IBGE unique identifier of the municipality which you want the data. The list of municipalities and its codes might be requested with the function owdbr::munlist()}

\item{AAAA}{Year of the data (AAAA format)}

\item{MM}{Month of the data (MM format)}

\item{PAGE}{Request's page. In normal situations: page=1.}
}
\value{
a tibble with the requested data, if there are more than one IBGECODE, returns all of them in the same tibble.
\describe{
  \item{table.dataReferencia}{Reference date}
  \item{table.valor}{Amount of money invested in the municipality.}
  \item{table.quantidadeBeneficiados}{Number of citizens wich are enrolled in the program in that moment}
  \item{table.municipio.codigoIBGE}{IBGE code of the municipality.}
  \item{table.municipio.nomeIBGE}{Name of the municipality.}
  \item{table.municipio.pais}{Country of the municipality.}
  \item{table.municipio.uf.sigla}{Abbreviation of name of the state in which the municipality is.}
  \item{table.municipio.uf.nome}{Full name of the state in wich the municipality is.}
  \item{table.tipo.id}{Type}
  \item{table.tipo.descricao}{Abbreviation of the program's name.}
  \item{table.tipo.descricaoDetalhada}{Full name of the program.}
  }
}
\description{
The program BOLSA FAMILIA is a brazilian social welfare program that provides financial aid for poor families.
This function collects municipal level data from the program, some data like the number of citizens in a municipality wich are enrolled in the program, and the total amound of money invested by the program in that city.
}
\examples{
getpbf_mun('3304557', AAAA='2015', MM='05', PAGE=1)

}
\author{
Joao Pedro Oliveira dos Santos, International Relations Institute, Pontifical Catholic University of Rio de Janeiro
}
