% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview_plot.R
\name{overview_plot}
\alias{overview_plot}
\title{overview_plot}
\usage{
overview_plot(
  dat,
  id,
  time,
  xaxis = "Time frame",
  yaxis = "Sample",
  asc = TRUE,
  color,
  dot_size = 2
)
}
\arguments{
\item{dat}{Your data set}

\item{id}{Your scope (e.g., country codes or individual IDs). If the id
variable contains NAs, they will not be included in the plot.}

\item{time}{Your time (e.g., time periods given by years, months, ...)}

\item{xaxis}{Label of the x axis ("Time frame" is default)}

\item{yaxis}{Label of the y axis ("Sample" is default)}

\item{asc}{Sorting the y axis in ascending order ("TRUE" is default)}

\item{color}{Optional argument that defines the color}

\item{dot_size}{Option argument that defines the dot size (default is 2)}
}
\value{
A ggplot figure that presents the sample information visually
}
\description{
This function plots a ggplot to visualize the distribution of
    scope objects across the time frame.
}
\examples{
data(toydata)
overview_plot(dat = toydata, id = ccode, time = year)
}
