% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{Resume}
\alias{Resume}
\title{Resumes an interrupted file-backed MCMC}
\usage{
Resume(backing.path)
}
\arguments{
\item{backing.path}{directory path where the (partially completed) MCMC
samples were saved}
}
\value{
A list of either \code{\link{matrix}} or \code{\link{big.matrix}}
  with the MCMC samples.  Each row in the matrices corresponds to one sample
  from the MCMC chain.
}
\description{
\code{Resume} will finish a file-backed MCMC that was interrupted.  To resume
an MCMC run, specify the MCMC's backing path and the sampling will continue
from the last completed sample in the chain.  Note, however, that the random
number generator state from when the MCMC was interrupted is \emph{not}
restored, so the resulting chain my not be reproducible, even if a seed was
specified before the sampling was interrupted.
}
\examples{
# Setup the MCMC
n.iter <- 5
SampleX <- function(x) x + 1
backing.path <- tempfile()
dir.create(backing.path)
x <- 0
interrupt.mcmc <- TRUE
Mcmc <- InitMcmc(n.iter, backing.path=backing.path)

# Interrupt the MCMC during the third iteration
try({
    samps <- Mcmc({
        x <- SampleX(x)
        if(x==3 && interrupt.mcmc) break
    })
}, silent=TRUE)

# The sampling is incomplete
samps <- LoadMcmc(backing.path)
samps$x[,]
rm(samps)

# Resume the MCMC
interrupt.mcmc <- FALSE
samps <- Resume(backing.path)

# All samples are available
samps$x[,]
}
\seealso{
\code{\link{InitMcmc}}
}
