% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outbreaker_chains_methods.R
\name{print.outbreaker_chains}
\alias{print.outbreaker_chains}
\alias{outbreaker_chains}
\alias{plot.outbreaker_chains}
\alias{summary.outbreaker_chains}
\alias{plot.outbreaker_chains}
\alias{summary.outbreaker_chains}
\title{Basic methods for processing outbreaker results}
\usage{
\method{print}{outbreaker_chains}(x, n_row = 3, n_col = 8, ...)

\method{plot}{outbreaker_chains}(x, y = "post", type = c("trace", "hist",
  "density", "alpha", "t_inf", "kappa", "network"), burnin = 0,
  min_support = 0.1, ...)

\method{summary}{outbreaker_chains}(object, burnin = 0, ...)
}
\arguments{
\item{x}{an \code{outbreaker_chains} object as returned by \code{outbreaker}.}

\item{n_row}{the number of rows to display in head and tail; defaults to 3.}

\item{n_col}{the number of columns to display; defaults to 8.}

\item{...}{further arguments to be passed to other methods}

\item{y}{a character string indicating which result to plot}

\item{type}{a character string indicating the kind of plot to be used (see details)}

\item{burnin}{the number of iterations to be discarded as burnin}

\item{min_support}{a number between 0 and 1 indicating the minimum support of
ancestries to be plotted; only used if 'type' is 'network'}

\item{object}{an \code{outbreaker_chains} object as returned by \code{outbreaker}.}
}
\description{
Several methods are defined for instances of the class
\code{outbreaker_chains}, returned by \code{\link{outbreaker}}, including:
\code{print}, \code{plot}
}
\details{
'trace' for the MCMC trace, 'hist' for histograms, 'density' for a
kernel density estimation
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
