% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{PlotCatVar}
\alias{PlotCatVar}
\title{Create plots and summary statistics for a categorical variable}
\usage{
PlotCatVar(myVar, dataFl, weightNm = NULL, dateNm, dateGp, kCategories = 9,
  normBy = "time")
}
\arguments{
\item{myVar}{The name of the variable to be plotted}

\item{dataFl}{A \code{data.table} of data; must be the output of the
\code{\link{PrepData}} function.}

\item{weightNm}{Name of the variable containing row weights, or \code{NULL} for 
no weights (all rows receiving weight 1).}

\item{dateNm}{Name of column containing the date variable.}

\item{dateGp}{Name of the variable that the time series plots should be 
grouped by. Options are \code{NULL}, \code{"weeks"}, \code{"months"}, 
\code{"quarters"}, \code{"years"}. See \code{\link[data.table]{IDate}} for
details. If \code{NULL}, then \code{dateNm} will be used as \code{dateGp}.}

\item{kCategories}{If a categorical variable has more than \code{kCategories},
trace plots of only the \code{kCategories} most prevalent categories are
plotted.}

\item{normBy}{The normalization factor for rate plots, can be \code{"time"}
or \code{"var"}. If \code{"time"}, then for each time period of 
\code{dateGp}, counts are normalized by the total counts over all 
categories in that time period. This illustrates changes of categories' 
proportions over time. If \code{"var"}, then for each category, its counts 
are normalized by the total counts over time from only this category. This
illustrates changes of categories' volumes over time.}
}
\value{
\item{p}{A \code{grob} (i.e., \code{ggplot} grid) object, including a 
    bar plot, and trace plots of categories' proportions. If the number of 
    categories is larger than \code{kCategories}, then trace plots of only the
    \code{kCategories} most prevalent categories are be plotted. For a binary
    variable, only the trace plot of the less prevalent category is plotted.}
  \item{catVarSummary}{A \code{data.table}, contains categories' proportions 
    globally, and over-time in each time period in \code{dateGp}. Each row is
    a category of the categorical (or binary) variable \code{myVar}. The row
    whose \code{category == 'NA'} corresponds to missing. Categories are 
    ordered by global prevalence in a descending order.}
}
\description{
Output plots include a bar plot with cateogries ordered by global counts,
and trace plots of categories' proportions over time. This function is also
appliable to a binary varible, which is treated as categorical in this 
package. In addition to plots, a \code{data.table} of summary statistics
are generated, on global counts and proportions by cateory, and proportions 
by category over time.
}
\section{License}{

Copyright 2017 Capital One Services, LLC Licensed under the Apache License,
Version 2.0 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the  License at
http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
or agreed to in writing, software distributed under the License is 
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
KIND, either express or implied. See the License for the specific language 
governing permissions and limitations under the License.
}

\examples{
data(bankData)
bankData <- PrepData(bankData, dateNm = "date", dateGp = "months", 
                    dateGpBp = "quarters", weightNm = NULL)
# Single histogram is plotted for job type since there are 12 categories
plot(PlotCatVar(myVar = "job", dataFl = bankData, weightNm =  NULL, 
                     dateNm = "date", dateGp = "months")$p)
                     
plot(PlotCatVar(myVar = "job", dataFl = bankData, weightNm = NULL, 
                     dateNm = "date", dateGp = "months", kCategories = 12)$p)


## Binary data is treated as categorical,  and only the less frequent 
## category is plotted over time.
plot(PlotCatVar(myVar = "default", dataFl = bankData, weightNm = NULL, 
                     dateNm = "date", dateGp = "months")$p)
}
\seealso{
Functions depend on this function:
         \code{\link{PlotVar}},
         \code{\link{PrintPlots}},
         \code{\link{vlm}}.

This function depends on:
         \code{\link{PlotBarplot}},
         \code{\link{PlotRatesOverTime}},
         \code{\link{PrepData}}.
}
