% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatNumerics.R
\name{formatNumerics}
\alias{formatNumerics}
\title{formatNumerics}
\usage{
formatNumerics(
  object,
  digits = ospsuiteUtilsEnv$formatNumericsDigits,
  scientific = FALSE
)
}
\arguments{
\item{object}{An R object such as a list, a data.frame, character or numeric values.}

\item{digits}{Number of decimal digits to render}

\item{scientific}{Logical value defining if scientific writing is rendered}
}
\value{
Numeric values are rendered as character values. If \code{object} is a
data.frame or a list, a data.frame or list is returned with numeric values
rendered as character values.
}
\description{
Render numeric values of an \code{object} as character using the specified format:
\itemize{
\item If \code{object} is a data.frame or a list, \code{formatNumerics} applies on each of its fields
\item If \code{object} is of type character or integer, \code{formatNumerics} renders the values as is
\item If \code{object} is of type numeric, \code{formatNumerics} applies the defined format
}
}
\examples{
# Format array of numeric values
formatNumerics(log(c(12, 15, 0.3)), digits = 1, scientific = TRUE)

# Format a data.frame
x <- data.frame(parameter = c("a", "b", "c"), value = c(1, 110.4, 6.666))
formatNumerics(x, digits = 2, scientific = FALSE)
}
