% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation-helpers.R
\name{validateIsIncluded}
\alias{validateIsIncluded}
\title{Check if values are included}
\usage{
validateIsIncluded(values, parentValues, nullAllowed = FALSE)
}
\arguments{
\item{values}{A vector of values.}

\item{parentValues}{A vector of values where \code{values} are checked for
inclusion.}

\item{nullAllowed}{If \code{TRUE}, \code{value} can be \code{NULL} and the test always
passes. If \code{FALSE} (default), \code{NULL} is not accepted and the test fails.}
}
\value{
Returns \code{NULL} if child value is included in parent value set, otherwise
error is signaled.
}
\description{
Check if values are included
}
\examples{

A <- data.frame(
  col1 = c(1, 2, 3),
  col2 = c(4, 5, 6),
  col3 = c(7, 8, 9)
)

# will return NULL if child value is included in parent value set
validateIsIncluded("col3", names(A))

}
