% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-osmdata.R
\name{osmdata_sf}
\alias{osmdata_sf}
\title{Return an OSM Overpass query as an \code{osmdata} object in \code{sf} format.}
\usage{
osmdata_sf(q, doc, quiet = TRUE, encoding)
}
\arguments{
\item{q}{An object of class `overpass_query` constructed with \code{opq} and
\code{add_feature}. May be be omitted, in which case the
\code{osmdata} object will not include the query.}

\item{doc}{If missing, \code{doc} is obtained by issuing the overpass query,
\code{q}, otherwise either the name of a file from which to read data,
or an object of class \code{XML} returned from \code{osmdata_xml}.}

\item{quiet}{suppress status messages.}

\item{encoding}{Unless otherwise specified XML documents are assumed to be
encoded as UTF-8 or UTF-16. If the document is not UTF-8/16, and lacks
an explicit encoding directive, this allows you to supply a default.}
}
\value{
An object of class `osmdata` with the OSM components (points, lines,
        and polygons) represented in \code{sf} format.
}
\description{
Return an OSM Overpass query as an \code{osmdata} object in \code{sf} format.
}
\examples{
\dontrun{
hampi_sf <- opq ("hampi india") \%>\%
            add_feature (key="historic", value="ruins") \%>\%
            osmdata_sf ()
}
}
