% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CP_SIR.r
\name{CP_SIR}
\alias{CP_SIR}
\title{Counting process based sliced inverse regression model}
\usage{
CP_SIR(x, y, censor, bw = silverman(1, length(y)))
}
\arguments{
\item{x}{A matrix for features (continuous only).}

\item{y}{A vector of observed time.}

\item{censor}{A vector of censoring indicator.}

\item{bw}{Kernel bandwidth for nonparametric estimations (one-dimensional), the default is using Silverman's formula.}
}
\value{
A list consisting of
\item{values}{The eigenvalues of the estimation matrix}
\item{vectors}{The estimated directions, ordered by eigenvalues}
}
\description{
The CP-SIR model for right-censored survival outcome. This model is correct only under very strong assumptions, however, since it only requires an SVD, the solution is used as the initial value in the orthoDr optimization.
}
\examples{
# This is setting 1 in Sun et. al. (2017) with reduced sample size
library(MASS)
set.seed(1)
N = 200; P = 6
V=0.5^abs(outer(1:P, 1:P, "-"))
dataX = as.matrix(mvrnorm(N, mu=rep(0,P), Sigma=V))
failEDR = as.matrix(c(1, 0.5, 0, 0, 0, rep(0, P-5)))
censorEDR = as.matrix(c(0, 0, 0, 1, 1, rep(0, P-5)))
T = rexp(N, exp(dataX \%*\% failEDR))
C = rexp(N, exp(dataX \%*\% censorEDR - 1))
ndr = 1
Y = pmin(T, C)
Censor = (T < C)

# fit the model
cpsir.fit = CP_SIR(dataX, Y, Censor)
distance(failEDR, cpsir.fit$vectors[, 1:ndr, drop = FALSE], "dist")
}
\references{
Sun, Q., Zhu, R., Wang, T. and Zeng, D. "Counting Process Based Dimension Reduction Method for Censored Outcomes." (2017)
\url{https://arxiv.org/abs/1704.05046} .
}
