% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotmetal.R
\name{hotmetal}
\alias{hotmetal}
\title{Hot Metal Color Table}
\usage{
hotmetal(n = 64)
}
\arguments{
\item{n}{is the number of color levels (default = 64).}
}
\value{
A vector of character strings giving the colors in hexadecimal
format.
}
\description{
The hotmetal color table patterned after the one used in Matlab.
}
\details{
Based on the \code{tim.colors} function in the \pkg{fields} package.  The
\code{hotmetal} function has been modified to break any dependence on code
in the \pkg{fields} package.  Spline interpolation (\code{interpSpline}) is
used when the number of requested colors is not the default.
}
\examples{

hotmetal(10) 
image(outer(1:20,1:20,"+"), col=hotmetal(75), main="hotmetal")

}
\seealso{
\code{\link{terrain.colors}}, \code{\link{tim.colors}},
\code{\link{topo.colors}}
}
\keyword{aplot}

