% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cal_min.R
\docType{methods}
\name{cal_min-methods}
\alias{cal.min}
\alias{cal.min,anlz-method}
\alias{cal.min,nifti-method}
\alias{cal.min<-}
\alias{cal.min<-,anlz-method}
\alias{cal.min<-,nifti-method}
\alias{cal_min}
\alias{cal_min,anlz-method}
\alias{cal_min,nifti-method}
\alias{cal_min-methods}
\alias{cal_min-methods,}
\alias{cal_min<-}
\alias{cal_min<-,anlz-method}
\alias{cal_min<-,nifti-method}
\title{Extract Image Attribute \code{cal_min}}
\usage{
cal_min(object)

\S4method{cal_min}{nifti}(object)

\S4method{cal_min}{anlz}(object)

cal_min(object) <- value

\S4method{cal_min}{nifti}(object) <- value

\S4method{cal_min}{anlz}(object) <- value

cal.min(object)

\S4method{cal.min}{nifti}(object)

\S4method{cal.min}{anlz}(object)

cal.min(object) <- value

\S4method{cal.min}{nifti}(object) <- value

\S4method{cal.min}{anlz}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{cal_min} field.}
}
\description{
Methods that act on the \code{cal_min} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
\dontrun{
url <- "http://nifti.nimh.nih.gov/nifti-1/data/avg152T1_LR_nifti.nii.gz"
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
download.file(url, urlfile, quiet=TRUE)
}
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
mniLR <- readNIfTI(urlfile)
cal.min(mniLR)
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
ANALYZE 7.5\cr
\url{https://rportal.mayo.edu/bir/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}

