% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{gradient22}
\alias{gradient22}
\title{Gradient function for a subset of variables}
\usage{
gradient22(model, char_vars, values, par_int, weight_fun = function(x) 1)
}
\arguments{
\item{model}{formula describing the model, which must contain only \code{x}, the parameters defined in
\code{char_vars} and the numerical operators.}

\item{char_vars}{character vector of the parameters of the model.}

\item{values}{numeric vector with the nominal values of the parameters in \code{char_vars}.}

\item{par_int}{vector of indexes indicating the subset of variables to omit in the calculation of the gradient.}

\item{weight_fun}{optional one variable function that represents the square of the structure of variance, in case of heteroscedastic variance of the response}
}
\value{
A function depending on \code{x} that's the gradient of the \code{model} with respect to \code{char_vars}
}
\description{
Calculates the gradient function of a \code{model} with respect to a subset of the parameters given in
\code{par_int}, \code{char_vars}, evaluates it at the provided \code{values} and returns the result as
a function of the variable \code{x}.
}
