% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_xlsx.R
\name{write_xlsx}
\alias{write_xlsx}
\title{Write data to an xlsx file}
\usage{
write_xlsx(x, file, as_table = FALSE, ...)
}
\arguments{
\item{x}{object or a list of objects that can be handled by \code{\link[=write_data]{write_data()}} to write to file}

\item{file}{xlsx file name}

\item{as_table}{write using write_datatable as opposed to write_data}

\item{...}{optional parameters to pass to functions:
\itemize{
\item \code{\link[=wb_workbook]{wb_workbook()}}
\item \code{\link[=wb_add_worksheet]{wb_add_worksheet()}}
\item \code{\link[=wb_add_data]{wb_add_data()}}
\item \code{\link[=wb_freeze_pane]{wb_freeze_pane()}}
\item \code{\link[=wb_save]{wb_save()}}
}

see \strong{Details}.}
}
\value{
A workbook object
}
\description{
Write a \code{data.frame} or list of data.frames to an xlsx file
}
\details{
Optional parameters are:
\strong{wb_workbook Parameters}
\itemize{
\item \strong{creator} A string specifying the workbook author
}

\strong{wb_add_worksheet() Parameters}
\itemize{
\item \strong{sheet} Name of the worksheet
\item \strong{grid_lines} A logical. If \code{FALSE}, the worksheet grid lines will be hidden.
\item \strong{tab_color} Color of the worksheet tab. A valid color (belonging to \code{colors()})
or a valid hex color beginning with "#".
\item \strong{zoom} A numeric between 10 and 400. Worksheet zoom level as a percentage.
}

\strong{wb_add_data/wb_add_data_table Parameters}
\itemize{
\item \strong{start_col} A vector specifying the starting column(s) to write df
\item \strong{start_row} A vector specifying the starting row(s) to write df
\item \strong{col_names} If \code{TRUE}, column names of \code{x} are written.
\item \strong{row_names} If \code{TRUE}, row names of \code{x} are written.
\item \strong{na.strings} If not NULL NA values are converted to this string in Excel. Defaults to \code{NULL}.
}

\strong{wb_freeze_pane Parameters}
\itemize{
\item \strong{first_active_row} Top row of active region to freeze pane.
\item \strong{first_active_col} Furthest left column of active region to freeze pane.
\item \strong{first_row} If \code{TRUE}, freezes the first row (equivalent to \code{first_active_row = 2})
\item \strong{first_col} If \code{TRUE}, freezes the first column (equivalent to \code{first_active_col = 2})
}

\strong{wb_set_col_widths Parameters}
\itemize{
\item \strong{widths} May be a single value for all columns (or "auto"), or a list of vectors that will be recycled for each sheet (see examples)
}

\strong{wb_save Parameters}
\itemize{
\item \strong{overwrite} Overwrite existing file (Defaults to \code{TRUE} as with \code{wb_add_data()})
}

columns of \code{x} with class \code{Date} or \code{POSIXt} are automatically
styled as dates and datetimes respectively.
}
\examples{
## write to working directory
write_xlsx(iris, file = temp_xlsx(), col_names = TRUE)

write_xlsx(iris,
  file = temp_xlsx(),
  col_names = TRUE
)

## Lists elements are written to individual worksheets, using list names as sheet names if available
l <- list("IRIS" = iris, "MTCARS" = mtcars, matrix(runif(1000), ncol = 5))
write_xlsx(l, temp_xlsx(), col_widths = c(NA, "auto", "auto"))

## different sheets can be given different parameters
write_xlsx(l, temp_xlsx(),
  start_col = c(1, 2, 3), start_row = 2,
  as_table = c(TRUE, TRUE, FALSE), with_filter = c(TRUE, FALSE, FALSE)
)

# specify column widths for multiple sheets
write_xlsx(l, temp_xlsx(), col_widths = 20)
write_xlsx(l, temp_xlsx(), col_widths = list(100, 200, 300))
write_xlsx(l, temp_xlsx(), col_widths = list(rep(10, 5), rep(8, 11), rep(5, 5)))
}
\seealso{
\code{\link[=wb_add_worksheet]{wb_add_worksheet()}}, \code{\link[=wb_add_data]{wb_add_data()}}
}
