% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_person}
\alias{wb_add_person}
\alias{wb_get_person}
\alias{wb_add_thread}
\title{add threaded comment to worksheet}
\usage{
wb_add_person(wb, name = NULL, id = NULL, user_id = NULL, provider_id = "None")

wb_get_person(wb, name = NULL)

wb_add_thread(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  comment = NULL,
  person_id,
  reply = FALSE,
  resolve = FALSE
)
}
\arguments{
\item{wb}{a workbook}

\item{name}{the name to display}

\item{id}{(optional) the display id}

\item{user_id}{(optional) the user id}

\item{provider_id}{(optional) the provider id}

\item{sheet}{a worksheet}

\item{dims}{a cell}

\item{comment}{the comment to add}

\item{person_id}{the person Id this should be added for}

\item{reply}{logical if the comment is a reply}

\item{resolve}{logical if the comment should be marked as resolved}
}
\description{
These functions allow adding thread comments to spreadsheets. This is not yet supported by all spreadsheet software.
}
\details{
If a threaded comment is added, it needs a person attached with it. The default is to create a person with provider id \code{"None"}. Other providers are possible with specific values for \code{id} and \code{user_id}. If you require the following, create a workbook via spreadsheet software load it and get the values with \code{\link[=wb_get_person]{wb_get_person()}}
}
\examples{
wb <- wb_workbook()$add_worksheet()$
add_person(name = "openxlsx2")

pid <- wb$get_person(name = "openxlsx")$id

# write a comment to a thread, reply to one and solve some
wb <- wb \%>\%
  wb_add_thread(dims = "A1", comment = "wow it works!", person_id = pid) \%>\%
  wb_add_thread(dims = "A2", comment = "indeed", person_id = pid, resolve = TRUE) \%>\%
  wb_add_thread(dims = "A1", comment = "so cool", person_id = pid, reply = TRUE)
}
\seealso{
\code{\link[=wb_add_comment]{wb_add_comment()}}
}
\keyword{comments}
