% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-named-regions.R
\name{NamedRegions}
\alias{NamedRegions}
\alias{get_named_regions}
\title{Get create or remove named regions}
\usage{
get_named_regions(x)
}
\arguments{
\item{x}{An xlsx file or Workbook object}
}
\description{
Return a vector of named regions in a xlsx file or
Workbook object
}
\examples{
## create named regions
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")

## specify region
wb$add_data(sheet = 1, x = iris, startCol = 1, startRow = 1)
wb$add_named_region(
  sheet = 1,
  name = "iris",
  rows = seq_len(nrow(iris) + 1),
  cols = seq_along(iris)
)


## using write_data 'name' argument to create a named region
wb$add_data(sheet = 1, x = iris, name = "iris2", startCol = 10)

out_file <- temp_xlsx()
wb$save(out_file, overwrite = TRUE)

## see named regions
get_named_regions(wb) ## From Workbook object
get_named_regions(out_file) ## From xlsx file

## read named regions
df <- read_xlsx(wb, namedRegion = "iris")
head(df)

df <- read_xlsx(out_file, namedRegion = "iris2")
head(df)
}
\seealso{
\code{\link[=wb_add_named_region]{wb_add_named_region()}} \code{\link[=wb_remove_named_region]{wb_remove_named_region()}}
}
