% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{set_cell_style}
\alias{set_cell_style}
\title{helper set_cell_style}
\usage{
set_cell_style(wb, sheet, cell, value)
}
\arguments{
\item{wb}{a workbook}

\item{sheet}{a worksheet}

\item{cell}{a cell}

\item{value}{a value to assign}
}
\description{
helper set_cell_style
}
\examples{
# create a numeric data matrix
mat <- matrix(rnorm(28*28, mean = 44444, sd = 555), ncol = 28)
wb <- wb_workbook()$
  add_worksheet("test")$
  add_data("test", mat, colNames = FALSE)

# create known builtins 0 is the default
builtins <- c( # "0",
  "1", "2", "3", "4", "9", "10", "11", "12", "13", "14", "15", "16",
  "17", "18", "19", "20", "21", "22", "37", "38", "39", "40", "45", "46",
  "47", "48", "49"
)

# assign the style to the first row
for (builtin in builtins) {
  dim <- paste0(int2col(which(builtins \%in\% builtin)), "1")
  wb$add_cell_style(dims = dim,
                    numFmtId = builtin)
}

# new styles are 1:28, because s in a 0-index, they are in the
# order we just assigned them above
for (i in seq_along(wb$styles_mgr$styles$cellXfs)) {
  cell <- sprintf("\%s2:\%s28", int2col(i), int2col(i))
  wb$set_cell_style("test", cell, as.character(i))
}
}
