% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{ws_cell_merge}
\alias{ws_cell_merge}
\alias{wb_merge_cells}
\alias{wb_unmerge_cells}
\title{Worksheet cell merging}
\usage{
wb_merge_cells(wb, sheet = current_sheet(), rows = NULL, cols = NULL)

wb_unmerge_cells(wb, sheet = current_sheet(), rows = NULL, cols = NULL)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols, rows}{Column and row specifications to merge on.  Note: \code{min()} and
\code{max()} of each vector are provided for specs.  Skipping rows or columns is
not recognized.}
}
\description{
Merge cells within a worksheet
}
\details{
As merged region must be rectangular, only min and max of cols and
rows are used.
}
\examples{
# Create a new workbook
wb <- wb_workbook()

# Add a worksheets
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2")

# Merge cells: Row 2 column C to F (3:6)
wb <- wb_merge_cells(wb, "Sheet 1", cols = 2, rows = 3:6)

# Merge cells:Rows 10 to 20 columns A to J (1:10)
wb <- wb_merge_cells(wb, 1, cols = 1:10, rows = 10:20)

# Intersecting merges
wb <- wb_merge_cells(wb, 2, cols = 1:10, rows = 1)
wb <- wb_merge_cells(wb, 2, cols = 5:10, rows = 2)
wb <- wb_merge_cells(wb, 2, cols = c(1, 10), rows = 12) # equivalent to 1:10
try(wb_merge_cells(wb, 2, cols = 1, rows = c(1,10)))    # intersects existing merge

# remove merged cells
wb <- wb_unmerge_cells(wb, 2, cols = 1, rows = 1)  # removes any intersecting merges
wb <- wb_merge_cells(wb, 2, cols = 1, rows = 1:10) # Now this works

}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}}
}
\concept{workbook wrappers}
