% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keygen.R
\name{keygen}
\alias{keygen}
\alias{rsa_keygen}
\alias{dsa_keygen}
\alias{ec_keygen}
\alias{x25519_keygen}
\alias{ed25519_keygen}
\title{Generate Key pair}
\usage{
rsa_keygen(bits = 2048)

dsa_keygen(bits = 1024)

ec_keygen(curve = c("P-256", "P-384", "P-521"))

x25519_keygen()

ed25519_keygen()
}
\arguments{
\item{bits}{bitsize of the generated RSA/DSA key}

\item{curve}{which NIST curve to use}
}
\description{
The \code{keygen} functions generate a random private key. Use \code{as.list(key)$pubkey}
to derive the corresponding public key. Use \link{write_pem} to save a private key
to a file, optionally with a password.
}
\examples{
# Generate keypair
key <- rsa_keygen()
pubkey <- as.list(key)$pubkey

# Write/read the key with a passphrase
write_pem(key, "id_rsa", password = "supersecret")
read_key("id_rsa", password = "supersecret")
}
