% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histPlot.R
\name{histPlot}
\alias{histPlot}
\title{Histogram or hollow histogram}
\usage{
histPlot(
  x,
  col = fadeColor("black", "22"),
  border = "black",
  breaks = "default",
  probability = FALSE,
  hollow = FALSE,
  add = FALSE,
  lty = 2,
  lwd = 1,
  freqTable = FALSE,
  right = TRUE,
  axes = TRUE,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{Numerical vector or a frequency table (matrix) where the first
column represents the observed values and the second column the frequencies.
See also \code{freqTable} argument.}

\item{col}{Shading of the histogram bins.}

\item{border}{Color of histogram bin borders.}

\item{breaks}{A vector for the bin boundaries or an approximate number of
bins.}

\item{probability}{If \code{FALSE}, the frequency is plotted. If
\code{TRUE}, then a probability density.}

\item{hollow}{If \code{TRUE}, a hollow histogram will be created.}

\item{add}{If \code{TRUE}, the histogram is added to the plot.}

\item{lty}{Line type. Applies only if \code{hollow=TRUE}.}

\item{lwd}{Line width. Applies only if \code{hollow=TRUE}.}

\item{freqTable}{Set to \code{TRUE} if \code{x} is a frequency table.}

\item{right}{Set to \code{FALSE} to assign values of \code{x} that fall on a
bin margin to the left bin. Otherwise the ties default to the right bin.}

\item{axes}{If \code{FALSE}, the axes are not plotted.}

\item{xlab}{Label for the x axis.}

\item{ylab}{Label for the y axis.}

\item{xlim}{Limits for the x axis.}

\item{ylim}{Limits for the y axis.}

\item{\dots}{Additional arguments to \code{plot}. If \code{add} is
\code{TRUE}, these arguments are ignored.}
}
\description{
Create histograms and hollow histograms. This function permits easy color
and appearance customization.
}
\examples{


histPlot(tips$tip, main = "Tips")

# overlaid hollow histograms
histPlot(tips$tip[tips$day == "Tuesday"],
         probability = TRUE,
         hollow = TRUE,
         main = "Tips by day")
histPlot(tips$tip[tips$day == "Friday"],
         probability = TRUE,
         hollow = TRUE,
         add = TRUE,
         lty = 3,
         border = "red")
legend("topright",
       col = c("black", "red"),
       lty = 1:2,
       legend = c("Tuesday", "Friday"))

# breaks and colors
histPlot(tips$tip,
         col = fadeColor("yellow", "33"),
         border = "darkblue",
         probability = TRUE,
         breaks = 30,
         lwd = 3)

# custom breaks
brks <- c(-1, 0, 1, 2, 3, 4, seq(5, 20, 5), 22, 24, 26)
histPlot(tips$tip,
         probability = TRUE,
         breaks = brks,
         col = fadeColor("darkgoldenrod4", "33"),
         xlim = c(0, 26))

}
\seealso{
\code{\link{boxPlot}}, \code{\link{dotPlot}},
\code{\link{densityPlot}}
}
\author{
David Diez
}
