% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{MetadataFilter}
\alias{MetadataFilter}
\title{MetadataFilter}
\value{
Object of \code{\link[=R6Class]{R6Class()}} representing a list of \code{\link[=Process]{Process()}} in order to filter for collections.
}
\description{
Inheriting from \code{\link[=ProcessGraphArgument]{ProcessGraphArgument()}} in order to represent a list of functions that is internally
interpreted into \code{\link[=Process]{Process()}} objects.
}
\examples{
\dontrun{
# define filter statement
filter = list(
   "eo:cloud_cover" = function(x) x >= 0 & x < 50, 
   "platform" = function(x) x == "Sentinel-2A"
)

# setting the arguments is done via the process graph building with of 'processes()'
}

}
\seealso{
\code{\link[=Array]{Array()}}, \code{\link[=Integer]{Integer()}}, \code{\link[=EPSGCode]{EPSGCode()}}, \code{\link[=String]{String()}}, \code{\link[=Number]{Number()}},
\code{\link[=Date]{Date()}}, \code{\link[=RasterCube]{RasterCube()}}, \code{\link[=VectorCube]{VectorCube()}}, \code{\link[=ProcessGraphArgument]{ProcessGraphArgument()}},
\code{\link[=ProcessGraphParameter]{ProcessGraphParameter()}}, \code{\link[=OutputFormatOptions]{OutputFormatOptions()}}, \code{\link[=GeoJson]{GeoJson()}},
\code{\link[=Boolean]{Boolean()}}, \code{\link[=DateTime]{DateTime()}}, \code{\link[=Time]{Time()}}, \code{\link[=BoundingBox]{BoundingBox()}}, \code{\link[=Kernel]{Kernel()}},
\code{\link[=TemporalInterval]{TemporalInterval()}}, \code{\link[=TemporalIntervals]{TemporalIntervals()}}, \code{\link[=CollectionId]{CollectionId()}}, \code{\link[=OutputFormat]{OutputFormat()}},
\code{\link[=AnyOf]{AnyOf()}}, \code{\link[=ProjDefinition]{ProjDefinition()}}, \code{\link[=UdfCodeArgument]{UdfCodeArgument()}}, \code{\link[=UdfRuntimeArgument]{UdfRuntimeArgument()}} and
\code{\link[=UdfRuntimeVersionArgument]{UdfRuntimeVersionArgument()}},\code{\link[=TemporalIntervals]{TemporalIntervals()}}, \code{\link[=MetadataFilter]{MetadataFilter()}}
}
