% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/smoothTrend.R
\name{smoothTrend}
\alias{smoothTrend}
\title{Calculate nonparametric smooth trends}
\usage{
smoothTrend(mydata, pollutant = "nox", deseason = FALSE, type = "default",
  statistic = "mean", avg.time = "month", percentile = NA,
  data.thresh = 0, simulate = FALSE, n = 200, autocor = FALSE,
  cols = "brewer1", shade = "grey95", xlab = "year",
  y.relation = "same", ref.x = NULL, ref.y = NULL,
  key.columns = length(percentile), name.pol = pollutant, ci = TRUE,
  alpha = 0.2, date.breaks = 7, auto.text = TRUE, k = NULL, ...)
}
\arguments{
\item{mydata}{A data frame containing the field \code{date} and at least
one other parameter for which a trend test is required; typically (but
not necessarily) a pollutant.}

\item{pollutant}{The parameter for which a trend test is required.
Mandatory.}

\item{deseason}{Should the data be de-deasonalized first? If \code{TRUE}
the function \code{stl} is used (seasonal trend decomposition using
loess). Note that if \code{TRUE} missing data are first linearly
interpolated because \code{stl} cannot handle missing data.}

\item{type}{\code{type} determines how the data are split
i.e. conditioned, and then plotted. The default is will produce a
single plot using the entire data. Type can be one of the built-in
types as detailed in \code{cutData} e.g. \dQuote{season},
\dQuote{year}, \dQuote{weekday} and so on. For example, \code{type
= "season"} will produce four plots --- one for each season.

It is also possible to choose \code{type} as another variable in
the data frame. If that variable is numeric, then the data will be
split into four quantiles (if possible) and labelled
accordingly. If type is an existing character or factor variable,
then those categories/levels will be used directly. This offers
great flexibility for understanding the variation of different
variables and how they depend on one another.

Type can be up length two e.g. \code{type = c("season", "weekday")} will
  produce a 2x2 plot split by season and day of the week. Note, when two
  types are provided the first forms the columns and the second the rows.}

\item{statistic}{Statistic used for calculating monthly values. Default is
\dQuote{mean}, but can also be \dQuote{percentile}. See
\code{timeAverage} for more details.}

\item{avg.time}{Can be \dQuote{month} (the default), \dQuote{season} or
\dQuote{year}. Determines the time over which data should be
averaged. Note that for \dQuote{year}, six or more years are
required. For \dQuote{season} the data are plit up into spring: March,
April, May etc. Note that December is considered as belonging to
winter of the following year.}

\item{percentile}{Percentile value(s) to use if \code{statistic =
"percentile"} is chosen. Can be a vector of numbers e.g. \code{percentile
= c(5, 50, 95)} will plot the 5th, 50th and 95th percentile values
together on the same plot.}

\item{data.thresh}{The data capture threshold to use (%) when aggregating
the data using \code{avg.time}. A value of zero means that all available
data will be used in a particular period regardless if of the number of
values available. Conversely, a value of 100 will mean that all data will
need to be present for the average to be calculated, else it is recorded
as \code{NA}. Not used if \code{avg.time = "default"}.}

\item{simulate}{Should simulations be carried out to determine the
Mann-Kendall tau and p-value. The default is \code{FALSE}. If
\code{TRUE}, bootstrap simulations are undertaken, which also account for
autocorrelation.}

\item{n}{Number of bootstrap simulations if \code{simulate = TRUE}.}

\item{autocor}{Should autocorrelation be considered in the trend
uncertainty estimates? The default is \code{FALSE}. Generally, accounting
for autocorrelation increases the uncertainty of the trend estimate
sometimes by a large amount.}

\item{cols}{Colours to use. Can be a vector of colours e.g. \code{cols =
c("black", "green")} or pre-defined openair colours --- see
\code{openColours} for more details.}

\item{shade}{The colour used for marking alternate years. Use
\dQuote{white} or \dQuote{transparent} to remove shading.}

\item{xlab}{x-axis label, by default \dQuote{year}.}

\item{y.relation}{This determines how the y-axis scale is
plotted. "same" ensures all panels use the same scale and "free"
will use panel-specfic scales. The latter is a useful setting when
plotting data with very different values.  ref.x See \code{ref.y}
for details. In this case the correct date format should be used
for a vertical line e.g.  \code{ref.x = list(v =
as.POSIXct("2000-06-15"), lty = 5)}.}

\item{ref.x}{See \code{ref.y}.}

\item{ref.y}{A list with details of the horizontal lines to be
added representing reference line(s). For example, \code{ref.y =
list(h = 50, lty = 5)} will add a dashed horizontal line at
50. Several lines can be plotted e.g. \code{ref.y = list(h = c(50,
100), lty = c(1, 5), col = c("green", "blue"))}. See
\code{panel.abline} in the \code{lattice} package for more details
on adding/controlling lines.}

\item{key.columns}{Number of columns used if a key is drawn when using the
option \code{statistic = "percentile"}.}

\item{name.pol}{Names to be given to the pollutant(s). This is
useful if you want to give a fuller description of the variables,
maybe also including subscripts etc.}

\item{ci}{Should confidence intervals be plotted? The default is
\code{FALSE}.}

\item{alpha}{The alpha transparency of shaded confidence intervals - if
plotted. A value of 0 is fully transparent and 1 is fully opaque.}

\item{date.breaks}{Number of major x-axis intervals to use. The function
will try and choose a sensible number of dates/times as well as
formatting the date/time appropriately to the range being considered.
This does not always work as desired automatically. The user can
therefore increase or decrease the number of intervals by adjusting the
value of \code{date.breaks} up or down.}

\item{auto.text}{Either \code{TRUE} (default) or \code{FALSE}. If
\code{TRUE} titles and axis labels will automatically try and format
pollutant names and units properly e.g.  by subscripting the \sQuote{2}
in NO2.}

\item{k}{This is the smoothing parameter used by the \code{gam}
function in package \code{mgcv}. By default it is not used and the
amount of smoothing is optimised automatically. However, sometimes
it is useful to set the smoothing amount manually using \code{k}.}

\item{...}{Other graphical parameters are passed onto \code{cutData} and
\code{lattice:xyplot}. For example, \code{smoothTrend} passes the option
\code{hemisphere = "southern"} on to \code{cutData} to provide southern
(rather than default northern) hemisphere handling of \code{type = "season"}.
Similarly, common graphical arguments, such as \code{xlim} and \code{ylim}
for plotting ranges and \code{pch} and \code{cex} for plot symbol type and
size, are passed on \code{xyplot}, although some local modifications may
be applied by openair. For example, axis and title labelling options (such
as \code{xlab}, \code{ylab} and \code{main}) are passed to \code{xyplot} via
\code{quickText} to handle routine formatting. One special case here is
that many graphical parameters can be vectors when used with
\code{statistic = "percentile"} and a vector of \code{percentile} values,
see examples below.}
}
\value{
As well as generating the plot itself, \code{smoothTrend}
also returns an object of class ``openair''. The object includes
three main components: \code{call}, the command used to generate
the plot; \code{data}, the data frame of summarised information
used to make the plot; and \code{plot}, the plot itself. Note that
\code{data} is a list of two data frames: \code{data} (the
original data) and \code{fit} (the smooth fit that has details of
the fit and teh uncertainties). If retained, e.g. using
\code{output <- smoothTrend(mydata, "nox")}, this output can be
used to recover the data, reproduce or rework the original plot or
undertake further analysis.

An openair output can be manipulated using a number of generic operations,
  including \code{print}, \code{plot} and \code{summarise}.
}
\description{
Use non-parametric methods to calculate time series trends
}
\details{
The \code{smoothTrend} function provides a flexible way of
estimating the trend in the concentration of a pollutant or other
variable. Monthly mean values are calculated from an hourly (or
higher resolution) or daily time series. There is the option to
deseasonalise the data if there is evidence of a seasonal cycle.

\code{smoothTrend} uses a Generalized Additive Model (GAM) from
the \code{\link{gam}} package to find the most appropriate level
of smoothing.  The function is particularly suited to situations
where trends are not monotonic (see discussion with
\code{\link{TheilSen}} for more details on this). The
\code{smoothTrend} function is particularly useful as an
exploratory technique e.g. to check how linear or non-linear
trends are.

95% confidence intervals are shown by shading. Bootstrap estimates
of the confidence intervals are also available through the
\code{simulate} option.  Residual resampling is used.

Trends can be considered in a very wide range of ways, controlled by
setting \code{type} - see examples below.
}
\examples{
# load example data from package
data(mydata)

# trend plot for nox
smoothTrend(mydata, pollutant = "nox")

# trend plot by each of 8 wind sectors
\dontrun{smoothTrend(mydata, pollutant = "o3", type = "wd", ylab = "o3 (ppb)")}

# several pollutants, no plotting symbol
\dontrun{smoothTrend(mydata, pollutant = c("no2", "o3", "pm10", "pm25"), pch = NA)}

# percentiles
\dontrun{smoothTrend(mydata, pollutant = "o3", statistic = "percentile",
percentile = 95)}

# several percentiles with control over lines used
\dontrun{smoothTrend(mydata, pollutant = "o3", statistic = "percentile",
percentile = c(5, 50, 95), lwd = c(1, 2, 1), lty = c(5, 1, 5))}
}
\author{
David Carslaw
}
\seealso{
\code{\link{TheilSen}} for an alternative method of calculating
  trends.
}
\keyword{methods}

