/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import opennlp.tools.ngram.TokenList;
import opennlp.tools.ngram.TokenSet;

public class Token {
    private String mToken;

    private Token(String token) {
        if (token == null || token.length() == 0) {
            throw new IllegalArgumentException("token parameter must not be null!");
        }
        this.mToken = token;
    }

    public String getToken() {
        return this.mToken;
    }

    public int hashCode() {
        return this.mToken.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.mToken;
    }

    public static Token create(String token) {
        return TokenSet.getInstance().insert(new Token(token));
    }

    public static TokenList create(String[] tokenStrings) {
        if (tokenStrings == null) {
            throw new IllegalArgumentException();
        }
        Token[] tokens = new Token[tokenStrings.length];
        for (int i = 0; i < tokenStrings.length; ++i) {
            tokens[i] = Token.create(tokenStrings[i]);
        }
        return new TokenList(tokens);
    }
}

