/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.DataStream;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.IntegerPool;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.sentdetect.DefaultEndOfSentenceScanner;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.SDEventStream;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.util.Pair;

public class SentenceDetectorME
implements SentenceDetector {
    private MaxentModel model;
    private final ContextGenerator cgen;
    private final EndOfSentenceScanner scanner;
    private static final IntegerPool INT_POOL = new IntegerPool(100);
    private List sentProbs;

    public SentenceDetectorME(MaxentModel m) {
        this(m, new SDContextGenerator(DefaultEndOfSentenceScanner.eosCharacters), new DefaultEndOfSentenceScanner());
        this.sentProbs = new ArrayList(50);
    }

    public SentenceDetectorME(MaxentModel m, ContextGenerator cg) {
        this(m, cg, new DefaultEndOfSentenceScanner());
    }

    public SentenceDetectorME(MaxentModel m, ContextGenerator cg, EndOfSentenceScanner s) {
        this.model = m;
        this.cgen = cg;
        this.scanner = s;
    }

    public String[] sentDetect(String s) {
        int[] starts = this.sentPosDetect(s);
        if (starts.length == 0) {
            return new String[]{s};
        }
        boolean leftover = starts[starts.length - 1] != s.length();
        String[] sents = new String[leftover ? starts.length + 1 : starts.length];
        sents[0] = s.substring(0, starts[0]);
        for (int si = 1; si < starts.length; ++si) {
            sents[si] = s.substring(starts[si - 1], starts[si]);
        }
        if (leftover) {
            sents[sents.length - 1] = s.substring(starts[starts.length - 1]);
        }
        return sents;
    }

    private int getFirstWS(String s, int pos) {
        while (pos < s.length() && !Character.isWhitespace(s.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private int getFirstNonWS(String s, int pos) {
        while (pos < s.length() && Character.isWhitespace(s.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public int[] sentPosDetect(String s) {
        double sentProb = 1.0;
        this.sentProbs.clear();
        StringBuffer sb = new StringBuffer(s);
        List enders = this.scanner.getPositions(s);
        ArrayList<Integer> positions = new ArrayList<Integer>(enders.size());
        int end = enders.size();
        int index = 0;
        for (int i = 0; i < end; ++i) {
            Integer candidate = (Integer)enders.get(i);
            int cint = candidate;
            int fws = this.getFirstWS(s, cint + 1);
            if (i + 1 < end && (Integer)enders.get(i + 1) < fws) continue;
            Pair pair = new Pair(sb, candidate);
            double[] probs = this.model.eval(this.cgen.getContext((Object)pair));
            String bestOutcome = this.model.getBestOutcome(probs);
            sentProb *= probs[this.model.getIndex(bestOutcome)];
            if (!bestOutcome.equals("T") || !this.isAcceptableBreak(s, index, cint)) continue;
            if (index != cint) {
                positions.add(INT_POOL.get(this.getFirstNonWS(s, this.getFirstWS(s, cint + 1))));
                this.sentProbs.add(new Double(probs[this.model.getIndex(bestOutcome)]));
            }
            index = cint + 1;
        }
        int[] sentPositions = new int[positions.size()];
        for (int i = 0; i < sentPositions.length; ++i) {
            sentPositions[i] = (Integer)positions.get(i);
        }
        return sentPositions;
    }

    public double[] getSentenceProbabilities() {
        double[] sentProbArray = new double[this.sentProbs.size()];
        for (int i = 0; i < sentProbArray.length; ++i) {
            sentProbArray[i] = (Double)this.sentProbs.get(i);
        }
        return sentProbArray;
    }

    protected boolean isAcceptableBreak(String s, int fromIndex, int candidateIndex) {
        return true;
    }

    public static GISModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel((EventStream)es, (int)iterations, (int)cut);
    }

    public static GISModel train(File inFile, int iterations, int cut, EndOfSentenceScanner scanner) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        PlainTextByLineDataStream ds = new PlainTextByLineDataStream((Reader)reader);
        SDEventStream es = new SDEventStream((DataStream)ds, scanner);
        return GIS.trainModel((EventStream)es, (int)iterations, (int)cut);
    }

    private static void usage() {
        System.err.println("Usage: SentenceDetectorME trainData modelName");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        int ai = 0;
        String encoding = null;
        while (args[ai].startsWith("-")) {
            if (!args[ai].equals("-encoding")) continue;
            if (++ai < args.length) {
                encoding = args[ai];
                ++ai;
                continue;
            }
            SentenceDetectorME.usage();
        }
        File inFile = new File(args[ai++]);
        File outFile = new File(args[ai++]);
        try {
            SDEventStream es = new SDEventStream((DataStream)new PlainTextByLineDataStream((Reader)new InputStreamReader((InputStream)new FileInputStream(inFile), encoding)));
            GISModel mod = args.length > ai ? SentenceDetectorME.train(es, Integer.parseInt(args[ai++]), Integer.parseInt(args[ai++])) : SentenceDetectorME.train(es, 100, 5);
            System.out.println("Saving the model as: " + outFile);
            new SuffixSensitiveGISModelWriter(mod, outFile).persist();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

