/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.ngram.Dictionary;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.TagDictionary;

public class PosTagger
extends POSTaggerME {
    public PosTagger(String modelFile, Dictionary dict, TagDictionary tagdict) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(dict), tagdict);
    }

    public PosTagger(String modelFile, TagDictionary tagdict) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(null), tagdict);
    }

    public PosTagger(String modelFile, Dictionary dict) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(dict));
    }

    private static MaxentModel getModel(String name) {
        try {
            return new SuffixSensitiveGISModelReader(new File(name)).getModel();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: PosTagger [-d tagdict] [-di case_insensiteve_tagdict] model < tokenized_sentences");
            System.exit(1);
        }
        int ai = 0;
        boolean test = false;
        String tagdict = null;
        boolean caseSensitive = true;
        while (ai < args.length && args[ai].startsWith("-")) {
            if (args[ai].equals("-d")) {
                tagdict = args[ai + 1];
                ai += 2;
                continue;
            }
            if (!args[ai].equals("-di")) continue;
            tagdict = args[ai + 1];
            ai += 2;
            caseSensitive = false;
        }
        String model = args[ai++];
        String dictFile = null;
        if (ai < args.length) {
            dictFile = args[ai++];
        }
        PosTagger tagger = tagdict != null ? (dictFile != null ? new PosTagger(model, new Dictionary(dictFile), (TagDictionary)new POSDictionary(tagdict, caseSensitive)) : new PosTagger(model, new POSDictionary(tagdict, caseSensitive))) : (dictFile != null ? new PosTagger(model, new Dictionary(dictFile)) : new PosTagger(model, (Dictionary)null));
        if (test) {
            System.out.println(tagger.tag(args[ai]));
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String line = in.readLine();
            while (line != null) {
                System.out.println(tagger.tag(line));
                line = in.readLine();
            }
        }
    }
}

