% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.profile_perm_delete}
\alias{dsadmin.profile_perm_delete}
\title{Delete a permission from a DataSHIELD profile}
\usage{
dsadmin.profile_perm_delete(opal, name, subject, type = "user")
}
\arguments{
\item{opal}{Opal connection object.}

\item{name}{Profile name.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}
}
\description{
Delete a permission that was applied on a DataSHIELD profile. Silently returns when there is no such permission.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.profile_perm_add(o, 'default', c('andrei', 'valentina'), 'user', 'use')
dsadmin.profile_perm(o, 'default')
dsadmin.profile_perm_delete(o, 'default', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD profiles: 
\code{\link{dsadmin.profile}()},
\code{\link{dsadmin.profile_access}()},
\code{\link{dsadmin.profile_create}()},
\code{\link{dsadmin.profile_delete}()},
\code{\link{dsadmin.profile_enable}()},
\code{\link{dsadmin.profile_exists}()},
\code{\link{dsadmin.profile_init}()},
\code{\link{dsadmin.profile_perm}()},
\code{\link{dsadmin.profile_perm_add}()},
\code{\link{dsadmin.profile_rparser}()},
\code{\link{dsadmin.profiles}()}
}
\concept{DataSHIELD profiles}
