% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.users.R
\name{oadmin.user_exists}
\alias{oadmin.user_exists}
\title{Check user exists}
\usage{
oadmin.user_exists(opal, name)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{User name}
}
\description{
Check whether a user exists, either in the internal user registry (see \link{oadmin.users}) 
or as an external user that already logged in (see \link{oadmin.user_profiles}).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
if (!oadmin.user_exists(o, "foo"))
  oadmin.user_add(o, "foo", password = "bar123")
opal.logout(o)
}
}
\seealso{
Other user functions: 
\code{\link{oadmin.user_add}()},
\code{\link{oadmin.user_delete}()},
\code{\link{oadmin.user_enable}()},
\code{\link{oadmin.user_profile_delete}()},
\code{\link{oadmin.user_profiles}()},
\code{\link{oadmin.user_reset_password}()},
\code{\link{oadmin.users}()}
}
\concept{user functions}
