% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\alias{init_next}
\title{Initialize Class Instance}
\usage{
init(x, ...)

init_next(x, ...)
}
\arguments{
\item{x}{environment of class \code{"Instance"}}

\item{...}{named fields inherited by the class instance or passed to methods}
}
\value{
environment of class \code{"Instance"}
}
\description{
Function called on \code{\link{oClass}} instance when it is created. Users create \code{init} methods to
customize creation behavior for their Classes. All \code{init} methods should return the Instance.
\code{init_next} calls the objects next \code{init} methods. \code{init_next} should only be
used inside if \code{init}.
}
\section{Functions}{
\itemize{
\item \code{init_next}: Initialize the inherited Class.
}}

\examples{

Animal <- oClass("Animal")

init.Animal <- function(self, x, y){
  self$x <- x
  self$y <- y
  self
}

turtle <- Animal(5, 10)
turtle$x == 5    # TRUE
turtle$y == 10   # TRUE


}
