% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.R
\name{add_fields}
\alias{add_fields}
\title{Add Fields to oClasses and Other Objects}
\usage{
add_fields(x, ...)
}
\arguments{
\item{x}{oClass instance, generator, environment, list, or other object}

\item{...}{named objects to be added to \code{x}}
}
\value{
object of same type as \code{x} or list
}
\description{
For environments, oClass instances and generator, \code{add_fields} is a wrapper for
\code{\link[base]{list2env}}; it adds the objects in \code{...} the environment if they are named.
For list and other objects, it behaves similar to appending \code{...} as a list.
}
\examples{
clown <- oClass("clown")
add_fields(clown, laugh = "haha", is_funny=TRUE)

clown$laugh

}
