% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{create_sim_index}
\alias{create_sim_index}
\title{Create light-weight similarity index for fast lookups of between term set similarity.}
\usage{
create_sim_index(
  ontology,
  term_sets,
  information_content = descendants_IC(ontology),
  term_sim_method = "lin",
  combine = "average"
)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{term_sets}{List of character vectors of ontological term IDs.}

\item{information_content}{Numeric vector of information contents of terms (named by term)}

\item{term_sim_method}{Character string equalling either "lin" or "resnik" to use Lin or Resnik's expression for the similarity of terms.}

\item{combine}{Character string - either "average" or "product", indicating whether to use the best-match-product' method, or function accepting two arguments - the first, the similarity matrix obtained by averaging across term sets in \code{term_sets}, and the second averaging across those in \code{term_sets2}.}
}
\value{
Object of class \code{sim_index}.
}
\description{
Create light-weight similarity index for fast lookups of between term set similarity.
}
\seealso{
\code{link{get_sim}} \code{\link{get_sim_p}} \code{\link{sample_group_sim}}
}
